; Header File
; Created 13/10/2004; 19:31:59
conflib::get_num_key equ conflib@0000
;long value = conflib::get_num_key(const char *file, const char *key, long default, const short *error)
;*file = name of the file which contains the searched key
;        if *file doesn't exist, conflib will try to create it. In case of failure, conflib will return default value and error code will be conflib_FILE_NOT_FOUND
;*section = name of section in which the key will be searched. You can pass a NULL pointer if the searched key isn't in a section
;*key = name of the searched key
;        if *key doesn't exist, conflib will return default value and error code will be conflib_KEY_NOT_FOUND
;default = default value, which is returned in case of error (so, caller program doesn't need to catch errors)
;*error = pointer to short value, where the error will be stored
; if all is correct, *error = conflib_OK


conflib::add_num_key equ conflib@0001
;short error = conflib::add_num_key(const char *file, const char *key, long value)
;*file = name of the file which contains the key to store
;        if *file doesn't exist, conflib will try to create it. In case of failure, conflib will return default value and error code will be conflib_FILE_NOT_FOUND
;*section = name of section in which the key will be searched. You can pass a NULL pointer if the searched key isn't in a section
;*key = name of the key to store
;        if *key doesn't exist, conflib will create a new key
;value = value of the key
; if all is correct, error = conflib_OK


conflib::remove_key equ conflib@0002
;short error = conflib::remove_key(const char *file, const char *key)
;*file = name of the file which contains the key to remove
;        if *file doesn't exist, conflib will try to create it. In case of failure, conflib will return default value and error code will be conflib_FILE_NOT_FOUND
;*section = name of section in which the key will be searched. You can pass a NULL pointer if the searched key isn't in a section
;*key = name of the key to remove
;        if *key doesn't exist, the text remain unchanged.
;after this function, *file is unarchived (even the searched key doesn't exist).
;if there is not enough memory to remove the key, error will be conflib_UNSAVED_FILE
; if all is correct, error = conflib_OK


conflib::get_string_key equ conflib@0003
;error = short conflib::get_string_key(const char *file, const char *key, const char *value, long max_length, const char *default)
;*file = name of the file which contains the searched key
;        if *file doesn't exist, conflib will try to create it. In case of failure, conflib will return default value and error code will be conflib_FILE_NOT_FOUND
;*section = name of section in which the key will be searched. You can pass a NULL pointer if the searched key isn't in a section
;*key = name of the searched key
;        if *key doesn't exist, conflib will return default value and error code will be conflib_KEY_NOT_FOUND
;*value = pointer where the result will be stored
;max_length = maximum length of the result. The *value buffer must be at least (max_length-bytes+1) long (+1 for the terminating zero)
;*default = default value, which is written in case of error
;error = pointer to short value, where the error will be stored
; if all is correct, error = conflib_OK


conflib::add_string_key equ conflib@0004
;short error = conflib::add_string_key(const char *file, const char *key, const char *value)
;*file = name of the file which contains the key to store
;        if *file doesn't exist, conflib will try to create it. In case of failure, conflib will return default value and error code will be conflib_FILE_NOT_FOUND
;*section = name of section in which the key will be searched. You can pass a NULL pointer if the searched key isn't in a section
;*key = name of the key to store
;        if *key doesn't exist, conflib will create a new key
;*value = pointer to the value (standard C string)
; if all is correct, error = conflib_OK


;Error codes :
CONFLIB_OK equ 0
CONFLIB_FILE_NOT_FOUND equ 1
CONFLIB_KEY_NOT_FOUND equ 2
CONFLIB_INVALID_KEY equ 3
CONFLIB_UNSAVED_FILE equ 4
CONFLIB_UNARCHIVED_FILE equ 5
CONFLIB_CANT_CREATE_FILE equ 6
CONFLIB_SECTION_NOT_FOUND equ 7
